<?php

if (config('voyager.multilingual.enabled')) {
    Route::get('/greeting/{locale}', function ($locale) {
        $locales = config('voyager.multilingual.locales');
        if (!in_array($locale, $locales)) {
            //abort(400);
            abort(404);
        }

        app()->setLocale($locale);
        session()->put('locale', $locale);

        $locale = app()->currentLocale();

        //dd($locale);

        return redirect()->back();
    });
}

Route::group(['prefix' => 'admin'], function () {

    Voyager::routes();

    $config = array_merge(config('translation-manager.route'), ['namespace' => 'App\Http\Controllers']);

    Route::group($config, function ($router) {
        $router->get('view/{groupKey?}', 'TranslationManagerController@getView')->where('groupKey', '.*');
        $router->get('/{groupKey?}', 'TranslationManagerController@getIndex')->where('groupKey', '.*')->name('voyager.ltm-translations.index');
        $router->post('/add/{groupKey}', 'TranslationManagerController@postAdd')->where('groupKey', '.*');
        $router->post('/edit/{groupKey}', 'TranslationManagerController@postEdit')->where('groupKey', '.*');
        $router->post('/groups/add', 'TranslationManagerController@postAddGroup');
        $router->post('/delete/{groupKey}/{translationKey}', 'TranslationManagerController@postDelete')->where('groupKey', '.*');
        $router->post('/import', 'TranslationManagerController@postImport');
        $router->post('/find', 'TranslationManagerController@postFind');
        $router->post('/locales/add', 'TranslationManagerController@postAddLocale');
        $router->post('/locales/remove', 'TranslationManagerController@postRemoveLocale');
        $router->post('/publish/{groupKey}', 'TranslationManagerController@postPublish')->where('groupKey', '.*');
        $router->post('/translate-missing', 'TranslationManagerController@postTranslateMissing');
    });
});
