@extends('layouts.default')

@section('css')

@endsection

@section('content')

    <!-- Breadcrumb section start -->

    <section class="breadcrumb-section section-b-space">

        <ul class="circles">

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

        </ul>

        <div class="container">

            <div class="row">

                <div class="col-12">

                    <h3>Siparişi Onayla</h3>

                    <nav>

                        <ol class="breadcrumb">

                            <li class="breadcrumb-item">

                                <a href="{{ url('/') }}">

                                    <i class="fas fa-home"></i>

                                </a>

                            </li>

                            <li class="" aria-current="page">Anasayfa</li>

                        </ol>

                    </nav>

                </div>

            </div>

        </div>

    </section>

    <!-- Breadcrumb section end -->

    <!-- Cart Section Start -->

    <section class="section-b-space">

        <div class="container">

            <div class="col-lg-12">

                <!--            <h4 style="text-align: center">Şimdi <a href="uye-ol.php">Üye ol</a> %5 İndirim Kazan</h4>-->
                <template x-if="error">
                    <div class="alert alert-danger">
                        <ul>
                            <template x-for="[id, value] in Object.entries(errors)" :key="id">
                                <li class="d-block" x-text="value"></li>
                            </template>
                        </ul>
                    </div>
                </template>
            </div>

            <div class="row g-4">

                <div class="col-lg-8">

                    <h3 class="mb-3">Bilgiler</h3>

                    <form class="needs-validation">

                        <div class="row g-4">

                            <div class="col-md-6">

                                <label for="first_name" class="form-label">Adınız</label>

                                <input type="text" x-model="payment_details.first_name" class="form-control"
                                       id="first_name" placeholder="Adınızı Girin">

                            </div>

                            <div class="col-md-6">

                                <label for="last_name" class="form-label">Soyadınız</label>

                                <input type="text" x-model="payment_details.last_name" class="form-control"
                                       id="last_name" placeholder="Soyadınızı Girin">

                            </div>

                            <div class="col-md-12">

                                <label for="last_name" class="form-label">Tc Kimlik No</label>

                                <input type="text" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');" x-model="payment_details.tc_number" class="form-control"
                                       id="tc_number" placeholder="Tc Kimlik No Girin" maxlength="11">

                            </div>


                            {{-- <div class="col-md-6">

                                 <label for="lname" class="form-label">Kullanıcı adı</label>

                                 <div class="input-group">

                                     <span class="input-group-text" id="basic-addon1">@</span>

                                     <input type="text" class="form-control" placeholder="Kullanıcı adı" required>

                                 </div>

                             </div>--}}


                            <div class="col-md-6">

                                <label for="email" class="form-label">E-Mail Adresiniz</label>

                                <input type="email" x-model="payment_details.email" class="form-control" id="email"
                                       placeholder="example@example.com"

                                       required>

                            </div>


                            <div class="col-md-6">

                                <label for="phone" class="form-label">Telefon</label>

                                <input type="text" x-model="payment_details.phone" class="form-control" id="phone"
                                       placeholder=""
                                       required>

                            </div>


                            <div class="col-md-12">

                                <label for="address" class="form-label">Adres</label>

                                <input type="text" x-model="payment_details.address" class="form-control" id="address"
                                       aria-describedby="emailHelp"

                                       placeholder="1234 Ana Cadde" required>

                                <div class="invalid-feedback">

                                    Gönderim güncellemeleri için lütfen geçerli bir e-posta adresi girin.

                                </div>

                            </div>


                            <div class="col-md-6">

                                <label for="province" class="form-label">Şehir</label>

                                <select class="form-select custome-form-select" id="province"
                                        x-model="payment_details.province" @change="selectCity($event.target.value)">

                                    <option value="">Seçiniz</option>
                                    @foreach($cities as $city)
                                        <option value="{{ $city->isim }}">{{ $city->isim }}</option>
                                    @endforeach

                                </select>

                                <div class="invalid-feedback">

                                    Lütfen geçerli bir Şehir seçin.

                                </div>

                            </div>

                            <div class="col-md-6">

                                <label for="district" class="form-label">İlçe</label>

                                <select class="form-select custome-form-select" x-model="payment_details.district"
                                        id="district">
                                    <template x-for="country in countries">
                                        <option :value="country.isim"
                                                x-text="country.isim"></option>
                                    </template>
                                </select>

                                <div class="invalid-feedback">

                                    Lütfen geçerli bir İlçe Seçin.

                                </div>

                            </div>

                            <div class="col-md-6">

                                <label for="zip_code" class="form-label">Posta kodu</label>

                                <input type="text" x-model="payment_details.zip_code" class="form-control" id="zip_code"
                                       aria-describedby="emailHelp"

                                       placeholder="">

                            </div>
                            <div class="col-md-6">

                                <label for="burc" class="form-label">Burcunuz</label>

                                <select class="form-select custome-form-select" id="burc"
                                        x-model="payment_details.burc">

                                    <option value="">Seçiniz</option>

                                        <option value="koc">Koç</option>
                                        <option value="boga">Boğa </option>
                                        <option value="ikizler">İkizler </option>
                                        <option value="yengec">Yengeç </option>
                                        <option value="aslan">Aslan </option>
                                        <option value="basak">Başak </option>
                                        <option value="terazi">Terazi </option>
                                        <option value="akrep">Akrep </option>
                                        <option value="yay">Yay </option>
                                        <option value="oglak">Oğlak </option>
                                        <option value="kova">Kova  </option>
                                        <option value="balık">Balık  </option>


                                </select>

                                <div class="invalid-feedback">

                                    Lütfen burç seçin.

                                </div>

                            </div>

                        </div>

                        {{--<div class="form-check ps-0 mt-3 custome-form-check">

                            <input class="checkbox_animated check-it" type="checkbox" id="flexCheckDefault11">

                            <label class="form-check-label checkout-label" for="flexCheckDefault11">Bunu kaydet

                            </label>

                        </div>--}}


                        <hr class="my-lg-5 my-4">


                        {{--<h3 class="mb-3">Ödeme</h3>



                        <div class="d-block my-3">

                            <div class="form-check custome-radio-box">

                                <input class="form-check-input" type="radio" name="flexRadioDefault" id="credit">

                                <label class="form-check-label" for="credit">Kredi kartı</label>

                            </div>



                            <div class="form-check custome-radio-box">

                                <input class="form-check-input" type="radio" name="flexRadioDefault" id="debit">

                                <label class="form-check-label" for="debit">Banka kartı</label>

                            </div>



                            <div class="form-check custome-radio-box">

                                <input class="form-check-input" type="radio" name="flexRadioDefault" id="paypal">

                                <label class="form-check-label" for="paypal">PayPal</label>

                            </div>

                        </div>--}}

                        {{--<div class="row g-4">

                            <div class="col-md-6">

                                <label for="cc-name" class="form-label">Karttaki isim</label>

                                <input type="text" class="form-control" id="cc-name">

                                <div id="emailHelp" class="form-text">Kartta gösterildiği gibi tam ad</div>

                            </div>

                            <div class="col-md-6">

                                <label for="cc-number" class="form-label">Kredi Kartı Numarası</label>

                                <input type="text" class="form-control" id="cc-number" required="">

                                <div class="invalid-feedback">Kredi kartı numarası gerekli</div>

                            </div>

                            <div class="col-md-3">

                                <label for="expiration" class="form-label">Son Kullanma Tarihi</label>

                                <input type="text" class="form-control" id="expiration">

                            </div>

                            <div class="col-md-3">

                                <label for="cc-cvv" class="form-label">CVV</label>

                                <input type="text" class="form-control" id="cc-cvv">

                            </div>

                        </div>--}}

                        {{--<button class="btn btn-solid-default mt-4" type="submit">Ödemeye Devam Et</button>--}}

                    </form>

                </div>


                <div class="col-lg-4">

                    <div class="your-cart-box">

                        <h3 class="mb-3 d-flex text-capitalize">Sepetiniz<span

                                    class="badge bg-theme new-badge rounded-pill ms-auto bg-dark"
                                    x-text="cart_products.length">3</span>

                        </h3>

                        <ul class="list-group mb-3">

                            <template x-for="cart_product in cart_products">
                                <li class="list-group-item d-flex justify-content-between lh-condensed row m-0">

                                    <div class="col-12 p-0">

                                        <h6 class="my-0" x-text="cart_product.product.name"></h6>

                                        {{--<small>Kısa açıklama</small>--}}

                                    </div>
                                    <div class="col-12 text-end p-0">
                                        <span x-text="cart_product.product.sale_price+' ₺'"></span>
                                        <span class="mx-3" x-text="cart_product.quantity+' Adet'"></span>
                                        <span x-text="cart_product.total_price+' ₺'"></span>
                                    </div>

                                </li>
                            </template>
                            <li class="list-group-item d-flex justify-content-between lh-condensed row m-0">

                                <div class="col-12 p-0">

                                    <h6 class="my-0" x-text="cargo_price==0 ? 'Kargo Ücretsiz' : 'Kargo'"></h6>

                                </div>
                                <div class="col-12 text-end p-0">
                                    <span x-text="cargo_price+' ₺'"></span>
                                </div>

                            </li>


                            {{--<li class="list-group-item d-flex justify-content-between lh-condensed">

                                <div>

                                    <h6 class="my-0">İkinci ürün</h6>

                                    <small>Kısa açıklama</small>

                                </div>

                                <span>850 ₺</span>

                            </li>--}}

                            {{-- <li class="list-group-item d-flex justify-content-between lh-condensed active">

                                 <div class="text-dark">

                                     <h6 class="my-0">Promosyon kodu</h6>

                                     <small>ÖRNEK KOD</small>

                                 </div>

                                 <span>-545 ₺</span>

                             </li>--}}

                            <li class="list-group-item d-flex lh-condensed justify-content-between">

                                <span class="fw-bold">Toplam (TRY)</span>

                                <strong x-text="(cart_total+cargo_price)+' ₺'"></strong>

                            </li>

                        </ul>

                        <button class="btn btn-solid-default mt-4" id="checkout_btn" @click="checkout()">Ödemeye Devam Et</button>

                        {{--<form class="card border-0">

                            <div class="input-group custome-imput-group">

                                <input type="text" class="form-control" placeholder="Promosyon Kodu">

                                <div class="input-group-append">

                                    <button type="submit" class="btn btn-solid-default rounded-0">Kodu Onayla</button>

                                </div>

                            </div>

                        </form>--}}

                    </div>

                </div>

            </div>

        </div>

    </section>

    <!-- Cart Section End -->

@endsection

@section('js')

@endsection