<!DOCTYPE html>
<html lang="tr">

<head>

    <link rel="icon" href="assets/images/favicon/4.png" type="image/x-icon">
    <link rel="apple-touch-icon" href="assets/images/favicon/4.png">
    <meta name="theme-color" content="#51983c">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Voxo">
    <meta name="msapplication-TileImage" content="assets/images/favicon/4.png">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Welldress | Spor Gecelik / Sabahlık">
    <meta name="keywords" content="Welldress | Spor Gecelik / Sabahlık">
    <meta name="author" content="Lasera Medya">
    <link rel="icon" href="{{ asset('assets/images/favicon/6.png') }}" type="image/x-icon"/>
    <title>Welldress | Spor Gecelik / Sabahlık</title>

    <!-- Google font -->
    <link rel="preconnect" href="https://fonts.gstatic.com/">
    <link href="https://fonts.googleapis.com/css2?family=Rubik:wght@400;500;600;700&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700;800;900&amp;display=swap"
          rel="stylesheet">

    <!-- bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/bootstrap.css') }}">

    <!-- font-awesome css -->
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/font-awesome.css') }}">

    <!-- feather icon css -->
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/feather-icon.css') }}">

    <!-- animation css -->
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">

    <!-- slick css -->
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/slick/slick.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/slick/slick-theme.css') }}">

    <!-- Theme css -->
    <link id="color-link" rel="stylesheet" type="text/css" href="{{ asset('assets/css/demo6.css') }}">

    <!-- Theme css -->
    <link id="color-link" rel="stylesheet" type="text/css" href="{{ asset('assets/css/demo3.css') }}">
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.13.1/build/css/alertify.min.css"/>
    <script src="{{ asset('js/app.js') }}" defer></script>


</head>


<body class="theme-color6 light ltr">
<style>
    a.pointer:hover {
        cursor: pointer;
    }
</style>
<div x-data="aData()" x-init="init()">
@include('partials.header2')




<!-- Breadcrumb section start -->

    <section class="breadcrumb-section section-b-space">

        <ul class="circles">

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

            <li></li>

        </ul>

        <div class="container">

            <div class="row">

                <div class="col-12">

                    <h3>Siparişi Onayla</h3>

                    <nav>

                        <ol class="breadcrumb">

                            <li class="breadcrumb-item">

                                <a href="{{ url('/') }}">

                                    <i class="fas fa-home"></i>

                                </a>

                            </li>

                            <li class="" aria-current="page">Anasayfa</li>

                        </ol>

                    </nav>

                </div>

            </div>

        </div>

    </section>

    <!-- Breadcrumb section end -->

    <!-- Cart Section Start -->

    <section class="section-b-space">

        <div class="container">

            <div class="col-lg-12">

                <!--            <h4 style="text-align: center">Şimdi <a href="uye-ol.php">Üye ol</a> %5 İndirim Kazan</h4>-->
                <template x-if="error">
                    <div class="alert alert-danger">
                        <ul>
                            <template x-for="[id, value] in Object.entries(errors)" :key="id">
                                <li class="d-block" x-text="value"></li>
                            </template>
                        </ul>
                    </div>
                </template>
            </div>

            <div class="row g-4">

                <div class="col-lg-8">

                    <h3 class="mb-3">Bilgiler</h3>

                    <form class="needs-validation">

                        <div class="row g-4">

                            <div class="col-md-6">

                                <label for="first_name" class="form-label">Adınız</label>

                                <input type="text" x-model="payment_details.first_name" class="form-control"
                                       id="first_name" placeholder="Adınızı Girin">

                            </div>

                            <div class="col-md-6">

                                <label for="last_name" class="form-label">Soyadınız</label>

                                <input type="text" x-model="payment_details.last_name" class="form-control"
                                       id="last_name" placeholder="Soyadınızı Girin">

                            </div>

                            <div class="col-md-12">

                                <label for="last_name" class="form-label">Tc Kimlik No</label>

                                <input type="text"
                                       oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');"
                                       x-model="payment_details.tc_number" class="form-control"
                                       id="tc_number" placeholder="Tc Kimlik No Girin" maxlength="11">

                            </div>


                            {{-- <div class="col-md-6">

                                 <label for="lname" class="form-label">Kullanıcı adı</label>

                                 <div class="input-group">

                                     <span class="input-group-text" id="basic-addon1">@</span>

                                     <input type="text" class="form-control" placeholder="Kullanıcı adı" required>

                                 </div>

                             </div>--}}


                            <div class="col-md-6">

                                <label for="email" class="form-label">E-Mail Adresiniz</label>

                                <input type="email" x-model="payment_details.email" class="form-control" id="email"
                                       placeholder="example@example.com"

                                       required>

                            </div>


                            <div class="col-md-6">

                                <label for="phone" class="form-label">Telefon</label>

                                <input type="text" x-model="payment_details.phone" class="form-control" id="phone"
                                       placeholder=""
                                       required>

                            </div>


                            <div class="col-md-12">

                                <label for="address" class="form-label">Adres</label>

                                <input type="text" x-model="payment_details.address" class="form-control" id="address"
                                       aria-describedby="emailHelp"

                                       placeholder="1234 Ana Cadde" required>

                                <div class="invalid-feedback">

                                    Gönderim güncellemeleri için lütfen geçerli bir e-posta adresi girin.

                                </div>

                            </div>


                            <div class="col-md-6">

                                <label for="province" class="form-label">Şehir</label>

                                <select class="form-select custome-form-select" id="province"
                                        x-model="payment_details.province" @change="selectCity($event.target.value)">

                                    <option value="">Seçiniz</option>
                                    @foreach($cities as $city)
                                        <option value="{{ $city->isim }}">{{ $city->isim }}</option>
                                    @endforeach

                                </select>

                                <div class="invalid-feedback">

                                    Lütfen geçerli bir Şehir seçin.

                                </div>

                            </div>

                            <div class="col-md-6">

                                <label for="district" class="form-label">İlçe</label>

                                <select class="form-select custome-form-select" x-model="payment_details.district"
                                        id="district">
                                    <template x-for="country in countries">
                                        <option :value="country.isim"
                                                x-text="country.isim"></option>
                                    </template>
                                </select>

                                <div class="invalid-feedback">

                                    Lütfen geçerli bir İlçe Seçin.

                                </div>

                            </div>

                            <div class="col-md-6">

                                <label for="zip_code" class="form-label">Posta kodu</label>

                                <input type="text" x-model="payment_details.zip_code" class="form-control" id="zip_code"
                                       aria-describedby="emailHelp"

                                       placeholder="">

                            </div>
                            <div class="col-md-6">

                                <label for="burc" class="form-label">Burcunuz</label>

                                <select class="form-select custome-form-select" id="burc"
                                        x-model="payment_details.burc">

                                    <option value="">Seçiniz</option>

                                    <option value="koc">Koç</option>
                                    <option value="boga">Boğa</option>
                                    <option value="ikizler">İkizler</option>
                                    <option value="yengec">Yengeç</option>
                                    <option value="aslan">Aslan</option>
                                    <option value="basak">Başak</option>
                                    <option value="terazi">Terazi</option>
                                    <option value="akrep">Akrep</option>
                                    <option value="yay">Yay</option>
                                    <option value="oglak">Oğlak</option>
                                    <option value="kova">Kova</option>
                                    <option value="balık">Balık</option>


                                </select>

                                <div class="invalid-feedback">

                                    Lütfen burç seçin.

                                </div>

                            </div>

                        </div>

                        {{--<div class="form-check ps-0 mt-3 custome-form-check">

                            <input class="checkbox_animated check-it" type="checkbox" id="flexCheckDefault11">

                            <label class="form-check-label checkout-label" for="flexCheckDefault11">Bunu kaydet

                            </label>

                        </div>--}}


                        <hr class="my-lg-5 my-4">


                        {{--<h3 class="mb-3">Ödeme</h3>



                        <div class="d-block my-3">

                            <div class="form-check custome-radio-box">

                                <input class="form-check-input" type="radio" name="flexRadioDefault" id="credit">

                                <label class="form-check-label" for="credit">Kredi kartı</label>

                            </div>



                            <div class="form-check custome-radio-box">

                                <input class="form-check-input" type="radio" name="flexRadioDefault" id="debit">

                                <label class="form-check-label" for="debit">Banka kartı</label>

                            </div>



                            <div class="form-check custome-radio-box">

                                <input class="form-check-input" type="radio" name="flexRadioDefault" id="paypal">

                                <label class="form-check-label" for="paypal">PayPal</label>

                            </div>

                        </div>--}}

                        {{--<div class="row g-4">

                            <div class="col-md-6">

                                <label for="cc-name" class="form-label">Karttaki isim</label>

                                <input type="text" class="form-control" id="cc-name">

                                <div id="emailHelp" class="form-text">Kartta gösterildiği gibi tam ad</div>

                            </div>

                            <div class="col-md-6">

                                <label for="cc-number" class="form-label">Kredi Kartı Numarası</label>

                                <input type="text" class="form-control" id="cc-number" required="">

                                <div class="invalid-feedback">Kredi kartı numarası gerekli</div>

                            </div>

                            <div class="col-md-3">

                                <label for="expiration" class="form-label">Son Kullanma Tarihi</label>

                                <input type="text" class="form-control" id="expiration">

                            </div>

                            <div class="col-md-3">

                                <label for="cc-cvv" class="form-label">CVV</label>

                                <input type="text" class="form-control" id="cc-cvv">

                            </div>

                        </div>--}}

                        {{--<button class="btn btn-solid-default mt-4" type="submit">Ödemeye Devam Et</button>--}}

                    </form>

                </div>


                <div class="col-lg-4">

                    <div class="your-cart-box">

                        <h3 class="mb-3 d-flex text-capitalize">Sepetiniz<span

                                    class="badge bg-theme new-badge rounded-pill ms-auto bg-dark"
                                    x-text="cart_products.length">3</span>

                        </h3>

                        <ul class="list-group mb-3">

                            <template x-for="cart_product in cart_products">
                                <li class="list-group-item d-flex justify-content-between lh-condensed row m-0">

                                    <div class="col-12 p-0">

                                        <h6 class="my-0" x-text="cart_product.product.name"></h6>

                                        {{--<small>Kısa açıklama</small>--}}

                                    </div>
                                    <div class="col-12 text-end p-0">
                                        <span x-text="cart_product.product.sale_price+' ₺'"></span>
                                        <span class="mx-3" x-text="cart_product.quantity+' Adet'"></span>
                                        <span x-text="cart_product.total_price+' ₺'"></span>
                                    </div>

                                </li>
                            </template>
                            <li class="list-group-item d-flex justify-content-between lh-condensed row m-0">

                                <div class="col-12 p-0">

                                    <h6 class="my-0" x-text="cargo_price==0 ? 'Kargo Ücretsiz' : 'Kargo'"></h6>

                                </div>
                                <div class="col-12 text-end p-0">
                                    <span x-text="cargo_price+' ₺'"></span>
                                </div>

                            </li>


                            {{--<li class="list-group-item d-flex justify-content-between lh-condensed">

                                <div>

                                    <h6 class="my-0">İkinci ürün</h6>

                                    <small>Kısa açıklama</small>

                                </div>

                                <span>850 ₺</span>

                            </li>--}}

                            {{-- <li class="list-group-item d-flex justify-content-between lh-condensed active">

                                 <div class="text-dark">

                                     <h6 class="my-0">Promosyon kodu</h6>

                                     <small>ÖRNEK KOD</small>

                                 </div>

                                 <span>-545 ₺</span>

                             </li>--}}

                            <li class="list-group-item d-flex lh-condensed justify-content-between">

                                <span class="fw-bold">Toplam (TRY)</span>

                                <strong x-text="(cart_total+cargo_price)+' ₺'"></strong>

                            </li>

                        </ul>

                        <button class="btn btn-solid-default mt-4" id="checkout_btn" @click="checkout()">Ödemeye Devam
                            Et
                        </button>

                        {{--<form class="card border-0">

                            <div class="input-group custome-imput-group">

                                <input type="text" class="form-control" placeholder="Promosyon Kodu">

                                <div class="input-group-append">

                                    <button type="submit" class="btn btn-solid-default rounded-0">Kodu Onayla</button>

                                </div>

                            </div>

                        </form>--}}

                    </div>

                </div>

            </div>

        </div>

    </section>

    <!-- Cart Section End -->


@include('partials.footer')



<!-- tap to top Section Start -->
    <div class="tap-to-top">
        <a href="#home">
            <i class="fas fa-chevron-up"></i>
        </a>
    </div>
    <!-- tap to top Section End -->


    <div class="bg-overlay"></div>
</div>
<div id="iyzipay-checkout-form" class="responsive" style=""></div>
<!-- latest jquery-->
<script src="{{ asset('assets/js/jquery-3.5.1.min.js') }}"></script>

<!-- Bootstrap js-->
{{--<script src="{{ asset('assets/js/bootstrap/bootstrap.bundle.min.js') }}"></script>--}}

<!-- feather icon js-->
<script src="{{ asset('assets/js/feather/feather.min.js') }}"></script>


<!-- lazyload js-->
<script src="{{ asset('assets/js/lazysizes.min.js') }}"></script>


<!-- Notify js-->
{{--<script src="{{ asset('assets/js/bootstrap/bootstrap-notify.min.js') }}"></script>--}}

<!-- script js -->
{{--<script src="{{ asset('assets/js/theme-setting.js') }}"></script>--}}
<script src="{{ asset('assets/js/script.js') }}"></script>
@yield('js')


<script>

    @if ($errors->any())
    @foreach ($errors->all() as $error)
    alertify.warning('{{ $error }}');
    @endforeach
    @endif

    @if(Session::has('message'))

    @endif
</script>

<script>

    $('.color-image li').on('click', function () {
        $('.image-section-2 li').removeClass('active');
        ($(this).addClass('active'));

    });

    function aData() {
        return {
            cart_products: [],
            search_products: [],
            select_product: [],
            search: '',
            auth_user: [],
            cart_total: 0,
            color: [],
            size: null,
            payment_details: {
                first_name: '',
                last_name: '',
                tc_number: '',
                email: '',
                phone: '',
                address: '',
                province: '',
                district: '',
                zip_code: '',
                burc: '',
            },
            errors: [],
            error: false,
            cargo_price: 0,
            countries: [],
            init() {
                //this.getAuthUser();
                this.$watch('cart_products', value => this.calcTotal(value));
                this.$watch('search', value => this.findProducts(value));
                this.getCartProducts();
            },
            quickView(product_id) {
                const request = new Request('{{ url('get-find-product') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({"id": product_id})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        console.log(obj.body);
                        this.select_product = obj.body;
                    });
                var myModal = new bootstrap.Modal(document.getElementById('quick-view'), {});
                myModal.show();
            },
            findProducts(value) {
                const request = new Request('{{ url('get-search-products') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({"search": value})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.search_products = obj.body
                    });
            },
            findProduct(id) {
                const request = new Request('{{ url('get-find-product') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({"id": id})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.select_product = obj.body
                    });
            },
            cargo_calc() {
                this.cargo_price = 0;
                {{--if (this.cart_total < {{ setting('iyzico.free_cargo_price') }}) {--}}
                {{--    this.cargo_price = {!! setting('iyzico.cargo_price') !!};--}}
                {{--}--}}

            },
            getAuthUser() {
                const request = new Request('{{ url('get-auth-user') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.auth_user = obj.body;
                    });
            },
            setCartProduct(product_id, quantity = 1) {
                const request = new Request('{{ url('set-cart-products') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({
                        "product_id": product_id,
                        "quantity": quantity,
                        "color": this.color,
                        "size": this.size,
                    })
                });

                // fetch(request)
                //     .then(r => r.json().then(data => ({status: r.status, body: data})))
                //     .then(obj => {
                //         console.log(obj);
                //         this.updateCartProducts();
                //
                //         alertify.success('Ürün Sepete Eklendi');
                //     });

                // fetch(request)
                //     .then(r => r.json().then(data => ({status: r.status, body: data})))
                //     .then(obj => {
                //         console.log(obj);
                //         this.updateCartProducts();
                //
                //         alertify.success('Ürün Sepete Eklendi');
                //     });
                if (this.color.length > 0 && this.size) {
                    fetch(request)
                        .then(r => r.json().then(data => ({status: r.status, body: data})))
                        .then(obj => {
                            console.log(obj);
                            this.updateCartProducts();

                            alertify.success('Ürün Sepete Eklendi');
                        });
                } else {
                    if (this.color.length == 0)
                        alertify.warning('Ürün Sepete Eklenmedi. Renk Seçimi Zorunludur');

                    if (!this.size)
                        alertify.warning('Ürün Sepete Eklenmedi. Beden Seçimi Zorunludur');
                }


            },
            getCartProducts() {
                const request = new Request('{{ url('get-cart-products') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    //body: JSON.stringify({"name": data.name, "value": value})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.cart_products = obj.body
                    });
            },
            deleteCartProduct(product_id, quantity = 0) {
                //quantity 0 ise hepsini siliyor

                const request = new Request('{{ url('delete-cart-products') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({
                        "product_id": product_id,
                        "quantity": quantity,
                    })
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.updateCartProducts();
                    });
            },
            chanceCartProductQuantity(product_id, quantity, size) {
                if (quantity < 1)
                    return;
                const request = new Request('{{ url('chance-cart-product-quantity') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({
                        "product_id": product_id,
                        "quantity": quantity,
                        "size": size,
                    })
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        this.updateCartProducts();
                    });
            },
            clearCartProducts() {
                this.cart_products.forEach(element => {
                    this.deleteCartProduct(element.product_id);
                });
            },
            calcTotal(p) {
                var total = 0;
                p.forEach(function (item, index) {
                    // item.product.sale_price=item.product.sale_price.toFixed(2);
                    total += item.product.sale_price * item.quantity;
                });
                this.cart_total = total;
                // this.cart_total = total.toFixed(2);

                this.cargo_calc();

            },
            orderCreate() {
                if (this.cart_products.length > 0) {
                    const request = new Request('{{ url('order-create') }}', {
                        headers: {
                            "Content-Type": "application/json",
                            "Accept": "application/json, text-plain, */*",
                            "X-Requested-With": "XMLHttpRequest",
                            "X-CSRF-TOKEN": '{{ csrf_token() }}',
                        },
                        method: 'POST',
                        credentials: "same-origin",
                        body: JSON.stringify({"cart_total": this.cart_total})
                    });

                    fetch(request)
                        .then(r => r.json().then(data => ({status: r.status, body: data})))
                        .then(obj => {
                            this.order = obj.body;
                            console.log(this.order);
                            this.updateCartProducts();
                        });
                }
            },
            updateCartProducts() {
                this.getCartProducts();
            },
            addToWishlist(p_id) {
                if (p_id != null) {

                    const request = new Request('{{ url('begendigim-urunler') }}', {
                        headers: {
                            "Content-Type": "application/json",
                            "Accept": "application/json, text-plain, */*",
                            "X-Requested-With": "XMLHttpRequest",
                            "X-CSRF-TOKEN": '{{ csrf_token() }}',
                        },
                        method: 'POST',
                        credentials: "same-origin",
                        body: JSON.stringify({
                            "product_id": p_id,
                        })
                    });

                    fetch(request)
                        .then(r => r.json().then(data => ({status: r.status, body: data})))
                        .then(obj => {
                            if (obj.body !== true)
                                alertify.success('Ürün Favorilere Eklendi');
                            else
                                alertify.warning('Ürün Favorilerden Silindi');
                        });
                } else {
                    alertify.warning('Tekrar Deneyiniz');
                }
            },
            checkout() {
                $('#checkout_btn').prop('disabled', true);
                const request = new Request('{{ url('checkout') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, */*",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({
                        "cart_total": this.cart_total,
                        "payment_details": this.payment_details,
                    })
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        console.log(obj);
                        if (obj.body.errors) {
                            this.error = true;
                            this.errors = obj.body.errors;
                            $('#checkout_btn').prop('disabled', false);
                        } else {
                            let form = obj.body;
                            console.log(form);
                            console.log("--------------------------------------------------------------");
                            console.log((/Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent)));
                            console.log("--------------------------------------------------------------");
                            if (!(/Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent))) {

                                $("body").append(form);
                            } else {
                                $("#iyzipay-checkout-form").append(form);
                            }

                            //$('#checkout_btn').prop('disabled', false);
                        }


                    });

            },
            validateEmail(col) {
                alertify.warning(col);
            },
            selectCity(city) {
                const request = new Request('{{ url('getCountry') }}', {
                    headers: {
                        "Content-Type": "application/json",
                        "Accept": "application/json, text-plain, /",
                        "X-Requested-With": "XMLHttpRequest",
                        "X-CSRF-TOKEN": '{{ csrf_token() }}',
                    },
                    method: 'POST',
                    credentials: "same-origin",
                    body: JSON.stringify({"city_name": city})
                });

                fetch(request)
                    .then(r => r.json().then(data => ({status: r.status, body: data})))
                    .then(obj => {
                        console.log(obj.body);
                        this.countries = obj.body;
                    });
            },
        }
    }
</script>

<!-- Cookie Consent by https://www.PrivacyPolicies.com -->
<script type="text/javascript" src="//www.privacypolicies.com/public/cookie-consent/4.0.0/cookie-consent.js"
        charset="UTF-8"></script>
<script type="text/javascript" charset="UTF-8">
    document.addEventListener('DOMContentLoaded', function () {
        cookieconsent.run({
            "notice_banner_type": "headline",
            "consent_type": "implied",
            "palette": "light",
            "language": "tr",
            "page_load_consent_levels": ["strictly-necessary", "functionality", "tracking", "targeting"],
            "notice_banner_reject_button_hide": false,
            "preferences_center_close_button_hide": false,
            "page_refresh_confirmation_buttons": false,
            "website_name": "Welldress"
        });
    });
</script>


</body>
</html>


