@extends('layouts.default')

@section('css')

@endsection

@section('content')

    <!-- Sign Up Section Start -->

    <div class="login-section">

        <div class="materialContainer">

            <div class="box">

                <div class="login-title">

                    <h2>Üye Ol</h2>

                </div>

                <!-- Validation Errors -->
                <x-auth-validation-errors class="mt-4" :errors="$errors"/>

                <form method="POST" action="{{ route('register') }}">
                    @csrf
                    <div class="input">

                        <label for="name">Ad Soyad</label>

                        <input id="name" type="text" name="name" value="{{ old('name') }}" required autofocus>

                        <span class="spin"></span>

                    </div>


                    <div class="input">

                        <label for="email">Email</label>

                        <input id="email" type="email" name="email" value="{{ old('email') }}" required>

                        <span class="spin"></span>

                    </div>


                    <div class="input">

                        <label for="phone">Telefon</label>

                        <input id="phone" type="tel" name="phone" value="{{ old('phone') }}" required>

                        <span class="spin"></span>

                    </div>


                    <div class="input">

                        <label for="password">Şifre</label>

                        <input id="password" type="password" name="password"
                               required autocomplete="new-password">

                        <span class="spin"></span>

                    </div>


                    <div class="input">

                        <label for="password_confirmation">Şifre Onay</label>

                        <input id="password_confirmation" type="password" name="password_confirmation" required>

                        <span class="spin"></span>

                    </div>


                    <div class="button">

                        <input id="membership_agreement" type="checkbox" name="membership_agreement" x-ref="maCheckbox" @invalid="$refs.maCheckbox.setCustomValidity('Üyelik Sözleşmesini Kabul Etmelisiniz.');" required>
                        <a href="javascript:void(0)" data-bs-toggle="modal"
                           data-bs-target="#membership-agreement">Üyelik Sözleşmesini</a>

                    </div>


                    <div class="button login">

                        <button type="submit">

                            <span>Üye Ol</span>

                            <i class="fa fa-check"></i>

                        </button>

                    </div>
                </form>


                {{--

                                <p class="sign-category">

                                    <span>Veya şununla Kayıt Olun:</span>

                                </p>



                                <div class="row gx-md-3 gy-3">

                                    <div class="col-md-6">

                                        <a href="www.facebook.html">

                                            <div class="social-media fb-media">

                                                <img src="assets/images/inner-page/facebook.png" class="img-fluid blur-up lazyload"

                                                     alt="">

                                                <h6>Facebook</h6>

                                            </div>

                                        </a>

                                    </div>

                                    <div class="col-md-6">

                                        <a href="www.gmail.html">

                                            <div class="social-media google-media">

                                                <img src="assets/images/inner-page/google.png" class="img-fluid blur-up lazyload"

                                                     alt="">

                                                <h6>Google</h6>

                                            </div>

                                        </a>

                                    </div>

                                </div>
                --}}

                <p><a href="{{ route('login') }}" class="theme-color">Zaten hesabınız var mı?</a></p>

            </div>

        </div>

    </div>

    <!-- Sign Up Section End -->

    <!-- Quick view modal start -->
    <div class="modal fade membership-agreement-modal" id="membership-agreement">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <button type="button" class="btn-close m-3" data-bs-dismiss="modal" aria-label="Close" x-ref="maModalClose"></button>
                <div class="modal-body">
                    <div class="row pb-3">
                        <div class="col-12 text-center">
                            <h3>Üyelik Sözleşmesi</h3>
                        </div>
                        <div class="col-8 offset-2">
                            {!! setting('site.membership_agreement') !!}
                            <div class="mt-3 text-center">
                                <button class="btn btn-solid-default btn-block" @click="$refs.maCheckbox.checked = true; $refs.maModalClose.click();">

                                    <span>Kabul Et</span>

                                    <i class="fa fa-check"></i>

                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Quick view modal end -->

@endsection

@section('js')

@endsection