<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use TCG\Voyager\Facades\Voyager;

class Product extends Model
{
    use HasFactory;

    protected $appends = ['discount', 'sale_price'];

    public function category()
    {
        return $this->belongsTo(Voyager::model('Category'));
    }

    public function discount(): Attribute
    {
        $attribute = Attribute::make(
            get: fn() => $this->discount_rate == 0 ? false : true,
        );
        return $attribute;
    }

    public function salePrice(): Attribute
    {
        $attribute = Attribute::make(
            get: fn() => $this->discount ? (100 - $this->discount_rate) * $this->price / 100 : $this->price,
        //get: fn() => $this->price - ($this->price * $this->discount_rate / 100),
        );
        return $attribute;
    }

    public function getColor(){
        return $this->belongsToMany('App\Models\Color','product_colors');
    }
    public function getSizes(){
        return $this->belongsToMany('App\Models\Size','product_sizes');
    }
    public function colors()
    {
        return $this->belongsToMany('App\Models\Color', 'product_colors');
    }

    public function sizes()
    {
        return $this->belongsToMany('App\Models\Size', 'product_sizes');
    }
}
