<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;


class Order extends Model
{
    public function getStatus()
    {
        switch ($this->status) {
            case "0":
                return "Sipariş Kontrol Ediliyor";
            case "1":
                return "Siparişiniz Hazırlanıyor";
            case "2":
                return "Siparişiniz Hazırlandı";
            case "3":
                return "Kargoya Verildi";
            case "4":
                return "Teslim Edildi";

        }
    }

    public function getCargoCompany()
    {
        switch ($this->cargo_company) {
            case "0":
                return "Aras Kargo";
            case "1":
                return "Yurtiçi Kargo";
            case "2":
                return "MNG Kargo";
            case "3":
                return "Sürat Kargo";
            case "4":
                return "PTT Kargo";

        }
    }

    public function order_products()
    {
        return $this->hasMany('App\Models\OrderProduct')->with(['product', 'category']);
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function info(): Attribute
    {
        $attribute = Attribute::make(
            get: fn($value) => json_decode($value),
            set: fn($value) => $value ? json_encode($value) : json_encode([]),
        );
        return $attribute;
    }
}
