<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class CartProduct extends Model
{
    use HasFactory;

    protected $appends = ['total_price'];
    protected $fillable = ['product_id', 'user_id', 'ip_address', 'quantity'];

    public function product()
    {
        return $this->belongsTo('App\Models\Product')->with('category');
        //return $this->belongsTo('App\Models\Product','product_id','id')->with('category');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function totalPrice(): Attribute
    {
        $attribute = Attribute::make(
            get: fn() => $this->product->sale_price * $this->quantity,
        //get: fn() => $this->price - ($this->price * $this->discount_rate / 100),
        );
        return $attribute;
    }
}
