<?php

namespace App\Iyzico;

use App\Models\CartProduct;
use App\Models\Order;
use App\Models\OrderProduct;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Iyzipay\Model\Address;
use Iyzipay\Model\BasketItem;
use Iyzipay\Model\Buyer;
use Iyzipay\Model\CheckoutForm;
use Iyzipay\Model\CheckoutFormInitialize;
use Iyzipay\Model\Currency;
use Iyzipay\Model\Locale;
use Iyzipay\Model\PaymentGroup;
use Iyzipay\Options;
use Iyzipay\Request\CreateCheckoutFormInitializeRequest;
use Iyzipay\Request\RetrieveCheckoutFormRequest;

class Iyzipay
{
    /**
     * @var Options
     */
    protected $options;

    public function __construct()
    {
        $this->options = new Options();
        $this->options->setApiKey(setting('iyzico.api_key')); //BdJBBoYMBM3laBfZjhOcOOtdgHuEfzEm
        $this->options->setSecretKey(setting('iyzico.secret_key')); //Bnbk2iWmhzzWn0hXMspPlGjhRjOLupqW
        $this->options->setBaseUrl("https://api.iyzipay.com");
    }

    public function checkoutForm()
    {
        $token = request()->get('token');
        $rcf_request = new RetrieveCheckoutFormRequest();
        $rcf_request->setLocale(Locale::TR);
        $rcf_request->setConversationId("123456789");
        $rcf_request->setToken($token);

        $checkoutForm = CheckoutForm::retrieve($rcf_request, $this->options);
        if ($checkoutForm->getStatus() == 'success') {
            if ($checkoutForm->getPaymentStatus() == 'SUCCESS') {
                $order = Order::firstWhere('no', $checkoutForm->getBasketId());
                $order->payment_status = 'odeme_gerceklesti';
                $order->save();

                $where = [];
                if (auth()->check())
                {
                    $user = auth()->user();
                    $user_id = $user->id;
                }

                $ip = request()->ip();
                if (auth()->check())
                    $where['user_id'] = $user_id;
                else
                    $where['ip_address'] = $ip;

                //$cart_products = CartProduct::where($where)->delete();

                return redirect('/siparis-takibi/' . $order->no);
            }
            return redirect('/sepet')->withErrors('Bir sorun oluştu.Ödeme Başarısız');
        }
        return redirect('/sepet')->withErrors('Bir sorun oluştu.Ödeme Başarısız');
    }

    public function checkoutFormInitialize(Request $request)
    {
//        if (!auth()->check()) {
//            return response()->json(['errors' => ['auth' => ['Giriş Yapmanız gerekiyor.']]]);
//        }
        $user_id=0;
        $rules = [
            'first_name' => 'required|max:255',
            'last_name' => 'required|max:255',
            'email' => 'required|email:rfc,dns',
            'phone' => 'required',
            'address' => 'required',
            'province' => 'required',
            'district' => 'required',
            'zip_code' => 'required',
        ];

        $messages = [
            'first_name.required' => 'Ad mutlaka gereklidir.',
            'last_name.required' => 'Soyad mutlaka gereklidir.',
            'email.required' => 'Email mutlaka gereklidir.',
            'email.email' => 'Email mutlaka geçerli bir e-posta adresi olmalıdır.',
            'phone.required' => 'Telefon mutlaka gereklidir.',
            'address.required' => 'Adres mutlaka gereklidir.',
            'province.required' => 'Şehir mutlaka gereklidir.',
            'district.required' => 'İlçe mutlaka gereklidir.',
            'zip_code.required' => 'Posta Kodu mutlaka gereklidir.',
        ];

        $validator = Validator::make($request->payment_details, $rules, $messages);

        $payment_details = (object)$request->payment_details;

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()]);
        }

        $where = [];
        if (auth()->check())
        {
            $user = auth()->user();
            $user_id = $user->id;
        }

        $ip = request()->ip();
        if (auth()->check())
            $where['user_id'] = $user_id;
        else
            $where['ip_address'] = $ip;

        $cart_products = CartProduct::where($where)->with('product')->get();
        $basketItems = array();
        $total = 0;
        $i = 0;

        do {
            $code = $user_id . date('Y') . hexdec(uniqid());
        } while (Order::where("no", "=", $code)->first());

        $order = new Order;

        $order->user_id = $user_id;
        $order->ip_address = $ip;
        $order->payment_status = 'odeme_bekliyor';
        $order->cargo_price = 0;
        $order->no = $code;
        $order->info = $payment_details;

        if ($order->save()) {
            foreach ($cart_products as $cart) {

                $order_product = new OrderProduct;
                $order_product->order_id = $order->id;
                $order_product->product_id = $cart->product_id;
                $order_product->quantity = $cart->quantity;
                $order_product->price = $cart->product->price;
                $order_product->discount_rate = $cart->product->discount_rate;
                $order_product->category_id = 0;
                $order_product->product_name = $cart->product->name;
                $order_product->category_name = "-";
                $order_product->product_image = $cart->product->image;
                $order_product->color = $cart->color;
                $order_product->size = $cart->size;
                $order_product->save();

                //$cart->delete();

                $firstBasketItem = new BasketItem();
                $firstBasketItem->setId($order->id . "_prd_" . $order_product->id);
                $firstBasketItem->setName($order_product->product->name);
                $firstBasketItem->setCategory1("kategori");
                $firstBasketItem->setItemType(\Iyzipay\Model\BasketItemType::PHYSICAL);
                $firstBasketItem->setPrice($cart->total_price);
                //$total+=$item->product->price;
                $basketItems[$i] = $firstBasketItem;
                $total += $firstBasketItem->getPrice();
                $i++;
            }
            $order->total_price = $total;
            $order->save();
        } else return response()->json(false);

//        $cargo_price = setting('iyzico.free_cargo_price') >= $total ? setting('iyzico.cargo_price') : 0;
        $cargo_price =0;

        //return response()->json($total);

        $ccfi_request = new CreateCheckoutFormInitializeRequest();
        $ccfi_request->setLocale(Locale::TR);
        $ccfi_request->setConversationId("5465222");
        $ccfi_request->setPrice($total);
        $ccfi_request->setPaidPrice($total + $cargo_price);
        $ccfi_request->setCurrency(Currency::TL);
        $ccfi_request->setBasketId($code);
        $ccfi_request->setPaymentGroup(PaymentGroup::PRODUCT);
        $ccfi_request->setCallbackUrl(url('/odeme-sonuc'));
        $ccfi_request->setEnabledInstallments(array(2, 3, 6, 9));

        $buyer = new Buyer();
        $buyer->setId("BY789");
        $buyer->setName($payment_details->first_name);
        $buyer->setSurname($payment_details->last_name);
        $buyer->setGsmNumber($payment_details->phone);
        $buyer->setEmail($payment_details->email);
        $buyer->setIdentityNumber("74300864791");
        $buyer->setLastLoginDate("2015-10-05 12:43:35");
        $buyer->setRegistrationDate("2013-04-21 15:12:09");
        $buyer->setRegistrationAddress($payment_details->address);
        $buyer->setIp($ip);
        $buyer->setCity($payment_details->province);
        $buyer->setCountry("Turkey");
        $buyer->setZipCode($payment_details->zip_code);
        $ccfi_request->setBuyer($buyer);


        $shippingAddress = new Address();
        $shippingAddress->setContactName($payment_details->first_name." ".$payment_details->last_name);
        $shippingAddress->setCity("Istanbul");
        $shippingAddress->setCountry("Turkey");
        $shippingAddress->setAddress($payment_details->address);
        $shippingAddress->setZipCode("34742");
        $ccfi_request->setShippingAddress($shippingAddress);
        $ccfi_request->setBillingAddress($shippingAddress);

        $ccfi_request->setBasketItems($basketItems);

        $checkoutFormInitialize = CheckoutFormInitialize::create($ccfi_request, $this->options);
        return response()->json($checkoutFormInitialize->getCheckoutFormContent());
    }
}
