<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ChangePasswordController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function store(Request $request)
    {

        if (!Hash::check($request->current_password, auth()->user()->password)) {
            return back()->withErrors([
                'password' => ['Sağlanan şifre kayıtlarımızla eşleşmiyor.']
            ]);
        }

        $request->validate([
            'current_password' => 'required',
            'password' => 'required|confirmed',
        ],[
            'current_password.required'=>'Şifre mutlaka gereklidir.',
            'password.required'=>'Yeni şifre mutlaka gereklidir.',
            'password.confirmed'=>'Yeni şifre tekrarı eşleşmiyor.',
        ]);

        User::find(auth()->user()->id)->update(['password' => Hash::make($request->password)]);

        return back()->with([
            'password' => ['Password change successfully']
        ]);
    }
}